using System.Diagnostics.CodeAnalysis;
using Newtonsoft.Json;

namespace Tinycc.Resources;

[ExcludeFromCodeCoverage]
public class ShortenParams
{
    [JsonProperty("archived")]
    public bool? Archived { get; set; }

    [JsonProperty("custom_hash")]
    public string CustomHash { get; set; }

    [JsonProperty("email_stats")]
    public bool? EmailStats { get; set; }

    [JsonProperty("expiration_date")]
    public DateTime? ExpirationDate { get; set; }

    [JsonProperty("favorite")]
    public bool? Favorite { get; set; }

    [JsonProperty("long_url")]
    public string LongUrl { get; set; }

    [JsonProperty("max_clicks")]
    public int? MaxClicks { get; set; }

    [JsonProperty("no_stats")]
    public bool? NoStats { get; set; }

    [JsonProperty("note")]
    public string Note { get; set; }

    [JsonProperty("ping")]
    public bool? Ping { get; set; }

    [JsonProperty("protected")]
    public bool? Protected { get; set; }

    [JsonProperty("tags")]
    public IEnumerable<string> Tags { get; set; }
}
