﻿using Newtonsoft.Json.Linq;

namespace Tinycc.Helpers;

public static class HttpContentHelper
{
    public static async Task<JObject> GetContentAsync(HttpResponseMessage responseMessage)
    {
        string cnt = string.Empty;

        if (responseMessage.Content != null)
        {
            cnt = await responseMessage.Content.ReadAsStringAsync().ConfigureAwait(false);
        }

        JObject content;
        if (!string.IsNullOrEmpty(cnt) && responseMessage.Content.Headers.ContentType.MediaType == Constants.JsonMediaType)
        {
            content = JObject.Parse(cnt);
        }
        else
        {
            content = new JObject
            {
                { "StatusCode", new JValue((int)responseMessage.StatusCode) }
            };
        }

        return content;
    }
}
