Tinycc .NET client
==================

This is official .NET client for URL shortening service Tiny.cc (REST API v3.1).
Tiny.cc API has 'batch_operations_limit' which limits number of URLs you can affect in group operations.
However, sometimes you need to overcome this limitation. This client provides transparant 
handling of 'batch_operations_limit' using .NET async tasks for parralel handling of multiply connections.

Detailed API documentation:
https://tinycc.com/tiny/api-docs

Quick Start
===========

Client instantiation:

    Client client = new Client("johndow", "c3e49rce-ee35-44d9-a1bf-03522bd3b975");

Simple shortening:

    var result = await client.ShortenAsync("https://google.com");

Mass shortening:

    var result = await client.MassShortenAsync([
        new ShortenParams { LongUrl = "https://www.google.com", Tags = ["hrke"] },
        new ShortenParams { LongUrl = "https://yahoo.com", ExpirationDate = DateTime.Now.AddDays(1) },
    ]);

Delete URL:

	await client.DeleteAsync(hashes: ["hrke"]);

Create tag:

	await client.CreateTagAsync("foo");

Tag URL:

    var result = await client.EditAsync(new EditParams { Tags = ["+foo"] }, hashes: ["hrke"]);

Untag URL:

    var result = await client.EditAsync(new EditParams { Tags = ["-foo"] }, hashes: ["hrke"]);

Reset click stats of tagged URL:

	await client.ResetStatsAsync(tags: ["foo"]);

Read first tagged URL:

    var result = await client.ReadPageAsync(tags: ["foo"], limit: 1);

Since APIv3.1, all operation (by default) performed on "default" domain.
To select different domain, use this code:
    
    client.Domain = "my-domain.com";

Operations with tags, work across domains.
